//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_FileDataBase "Replay.db"
//+------------------------------------------------------------------+
#include "..\Service Graphics\Support\C_Array.mqh"
//+------------------------------------------------------------------+
class C_ReplayDataBase
{
	private	:
//+------------------------------------------------------------------+
		struct st_00
		{
			int 	handle,
					request;
		}m_Infos;
		C_Array 	m_Arr;
//+------------------------------------------------------------------+
		void Convert(const char &buff[], const int size)
		{
			string sz0 = "";
			bool b0, b1, bs1, bs2, bc0, bc1, bc;
			int nLine = 1;
			
			b0 = b1 = bs1 = bs2 = bc0 = bc1 = bc = false;
			for (int count = 0, nC0 = nLine; count < size; count++)
			{
				switch (buff[count])
				{
					case '\t':
						sz0 += (bs1 || bs2 ? "\t" : "");
						break;
					case '\n':
						nC0++;
					case '\r':
						bc0 = false;
						break;
					case ';':
						b0 = (bs1 || bs2 || bc0 || bc1 ? b0 : true);
					default:
						switch (buff[count])
						{
							case '"':
								bs1 = (bs2 || bc0 || bc1 ? bs1 : !bs1);
								break;
							case '\'':
								bs2 = (bs1 || bc0 || bc1 ? bs2 : !bs2);
								break;
						}
						if (((count + 1) < size) && (!bs1) && (!bs2))
						{
							if (bc = ((buff[count] == '-') && (buff[count + 1] == '-'))) bc0 = true;
							if (bc = ((buff[count] == '/') && (buff[count + 1] == '*'))) bc1 = true;
							if (bc = ((buff[count] == '*') && (buff[count + 1] == '/'))) bc1 = false;
							if (bc)
							{
								count += 1;
								bc = false;
								continue;
							}
						}
						if (!(bc0 || bc1))
						{
							if ((!b1) && (buff[count] > ' '))
							{
								b1 = true;
								nLine = nC0;
							}
							sz0 += (b1 ? StringFormat("%c", buff[count]) : "");
						}
				}
				if (b0)
				{
					m_Arr.Add(sz0, nLine);
					sz0 = "";
					b0 = b1 = false;
				}
			}
		}
//+------------------------------------------------------------------+
		const string ExecSQL(void)
		{
			string szCmd;
			
			for (int count = 0, nLine; count >= 0; count++)
			{
				szCmd = m_Arr.At(count, nLine);
				if (nLine < 0) break;
				if (!ExecCommandSQL(szCmd))
					return StringFormat("Execution of line %d of the SQL script failed...", nLine);
			}
			
			return NULL;
		}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_ReplayDataBase()
		{
			ZeroMemory(m_Infos);
			m_Infos.handle = DatabaseOpen(def_FileDataBase, DATABASE_OPEN_CREATE | DATABASE_OPEN_READWRITE);
			m_Infos.request = INVALID_HANDLE;
		}
//+------------------------------------------------------------------+
		~C_ReplayDataBase()
		{
			DatabaseClose(m_Infos.handle);
		}
//+------------------------------------------------------------------+
		const string ExecResourceSQL(const string szResource)
		{
			char buff[];
			int size;
			
			ArrayResize(buff, size = StringLen(szResource));
			StringToCharArray(szResource, buff);
			Convert(buff, size);
			ArrayFree(buff);
			
			return ExecSQL();
		}
//+------------------------------------------------------------------+
		bool ExecCommandSQL(const string szCmd)
		{
			return (m_Infos.handle == INVALID_HANDLE ? false : DatabaseExecute(m_Infos.handle, szCmd));
		}
//+------------------------------------------------------------------+
		bool ExecRequestOfData(const string szCmd)
		{
			if (m_Infos.request != INVALID_HANDLE) DatabaseFinalize(m_Infos.request);
			return ((m_Infos.request = DatabasePrepare(m_Infos.handle, szCmd)) != INVALID_HANDLE);
		}
//+------------------------------------------------------------------+
		template <typename T> bool GetRegisterOfRequest(T &stObject, const bool Finish = true)
		{
			if (DatabaseReadBind(m_Infos.request, stObject)) return true;
			if (Finish)
			{
				DatabaseFinalize(m_Infos.request);
				m_Infos.request = INVALID_HANDLE;
			}
			return false;
		}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_FileDataBase
//+------------------------------------------------------------------+